//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Runtime.InteropServices;

namespace ManagedCallback
{
	public delegate void IntegerEchoCallback(int index, int integerValue);
	public delegate void StringEchoCallback(int index, [MarshalAs(UnmanagedType.LPWStr)] string str);
	public delegate void FloatEchoCallback(int index, float floatValue);
	public delegate void DoubleEchoCallback(int index, double doubleValue);
	public class Native 
	{
		[DllImport("unmanaged.dll", CharSet=CharSet.Unicode)]
		public static extern void StringCallback(string [] stringArray, int nstrings, StringEchoCallback callback);
		[DllImport("unmanaged.dll")]
		public static extern void IntegerCallback(int [] intArray, int nints, IntegerEchoCallback callback);
		[DllImport("unmanaged.dll")]
		public static extern void FloatCallback(float [] floatArray, int nfloats, FloatEchoCallback callback);
		[DllImport("unmanaged.dll")]
		public static extern void DoubleCallback(double [] doubleArray, int ndoubles, DoubleEchoCallback callback);
	}
	/// <summary>
	/// Podsumowanie dla Class1.
	/// </summary>
	class ManagedCallbackMain
	{

		static void StringEcho(int index, string str)
		{
			Console.WriteLine("{0} - {1}", index, str);
		}
		static void IntegerEcho(int index, int integerValue)
		{
			Console.WriteLine("{0} - {1}", index, integerValue);
		}
		static void FloatEcho(int index, float floatValue)
		{
			Console.WriteLine("{0} - {1}", index, floatValue);
		}
		static void DoubleEcho(int index, double doubleValue)
		{
			Console.WriteLine("{0} - {1}", index, doubleValue);
		}

		static void Main(string[] args)
		{
			string [] sa = new string [] {"To", "jest", "test"};
			StringEchoCallback stringCallback = new StringEchoCallback(StringEcho);
			Native.StringCallback(sa, sa.Length, stringCallback);

			int [] ia = new int [] {1, 2, 3, 4, 5};
			IntegerEchoCallback integerCallback = new IntegerEchoCallback(IntegerEcho);
			Native.IntegerCallback(ia, ia.Length, integerCallback);

			float [] fa = new float [] {1, 2, 3, 4, 5};
			FloatEchoCallback floatCallback = new FloatEchoCallback(FloatEcho);
			Native.FloatCallback(fa, fa.Length, floatCallback);

			double [] da = new double [] {1.1, 2.2, 3.3, 4.4, 5.5, 6.6};
			DoubleEchoCallback doubleCallback = new DoubleEchoCallback(DoubleEcho);
			Native.DoubleCallback(da, da.Length, doubleCallback);
		}
	}
}
